<?php
/**
 * Change Class
 * https://webenginecms.org/
 * 
 * @version 1.0.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2020 Lautaro Angelico, All Rights Reserved
 * @build w641ba01901cb0925ec50f543e59acbd
 */

if(!isLoggedIn()) redirect(1,'login');

echo '<div class="page-title"><span>'.lang('changeclass_title').'</span></div>';

try {
	
	$ChangeClass = new \Plugin\ChangeClass\ChangeClass();
	$ChangeClass->setUserid($_SESSION['userid']);
	$ChangeClass->setUsername($_SESSION['username']);
	$accountCharacters = $ChangeClass->getAccountCharacters();
	$characterClasses = $ChangeClass->getCharacterClasses();
	
	if(isset($_GET['success'])) {
		message('success', lang('changeclass_success_1'));
	}
	
	if(isset($_POST['change_class_submit'])) {
		
		// CHANGE CLASS SUBMIT
		
		try {
			
			// wipe inventory agreement check
			if($ChangeClass->wipeInventoryEnabled()) {
				if(!check_value($_POST['change_class_agree_inventory'])) throw new Exception(lang('changeclass_error_8'));
			}
			
			// wipe skills agreement check
			if($ChangeClass->wipeSkillsEnabled()) {
				if(!check_value($_POST['change_class_agree_skills'])) throw new Exception(lang('changeclass_error_8'));
			}
			
			// wipe quests agreement check
			if($ChangeClass->wipeQuestsEnabled()) {
				if(!check_value($_POST['change_class_agree_quests'])) throw new Exception(lang('changeclass_error_8'));
			}
			
			// set new class
			$ChangeClass->setNewClass($_POST['change_class_new_class']);
			
			// set character
			$ChangeClass->setCharacter($_POST['change_class_character']);
			
			// change class
			$ChangeClass->performClassChange();
			
		} catch(Exception $ex) {
			message('error', $ex->getMessage());
		}
		
	} else {
		
		// CHANGE CLASS FORM
		
		echo '<form action="'.__CHANGECLASS_HOME__.'" method="post">';
			echo '<div class="row">';
				echo '<div class="col-xs-8 col-xs-offset-2">';
					
					echo '<h3>'.lang('changeclass_txt_1').'</h3>';
					echo '<select class="form-control" name="change_class_character">';
						echo '<option value=""></option>';
						foreach($accountCharacters as $row) {
							echo '<option value="'.$row.'">'.$row.'</option>';
						}
					echo '</select>';
					
				echo '</div>';
			echo '</div>';
			
			echo '<div class="row">';
				echo '<div class="col-xs-8 col-xs-offset-2">';
					
					echo '<h3>'.lang('changeclass_txt_2').'</h3>';
					echo '<select class="form-control" name="change_class_new_class">';
						echo '<option value=""></option>';
						foreach($characterClasses as $classId => $classInfo) {
							echo '<option value="'.$classId.'">'.$classInfo[0].'</option>';
						}
					echo '</select>';
					
				echo '</div>';
			echo '</div>';
			
			echo '<div class="row">';
				echo '<div class="col-xs-8 col-xs-offset-2">';
					
					echo '<h3>'.lang('changeclass_txt_3').'</h3>';
					echo '<ul>';
						if($ChangeClass->getRequiredLevel() > 0) echo '<li>'.langf('changeclass_txt_4', array($ChangeClass->getRequiredLevel())).'</li>';
						if($ChangeClass->getRequiredMasterLevel() > 0) echo '<li>'.langf('changeclass_txt_5', array($ChangeClass->getRequiredMasterLevel())).'</li>';
						if($ChangeClass->getRequiredResets() > 0) echo '<li>'.langf('changeclass_txt_6', array($ChangeClass->getRequiredResets())).'</li>';
						if($ChangeClass->getRequiredZen() > 0) echo '<li>'.langf('changeclass_txt_7', array(number_format($ChangeClass->getRequiredZen()))).'</li>';
						if($ChangeClass->getRequiredCredits() > 0) echo '<li>'.langf('changeclass_txt_8', array(number_format($ChangeClass->getRequiredCredits()))).'</li>';
					echo '</ul>';
					
				echo '</div>';
			echo '</div>';
			
			echo '<div class="row">';
				echo '<div class="col-xs-8 col-xs-offset-2">';
					
					if($ChangeClass->wipeInventoryEnabled()) {
					echo '<div class="checkbox">';
						echo '<label>';
							echo '<input type="checkbox" name="change_class_agree_inventory" value="1"> I understand that any equipped items and items in my inventory will be permanently deleted.';
						echo '</label>';
					echo '</div>';
					}
					
					if($ChangeClass->wipeSkillsEnabled()) {
					echo '<div class="checkbox">';
						echo '<label>';
							echo '<input type="checkbox" name="change_class_agree_skills" value="1"> I understand that my character skills will be cleared.';
						echo '</label>';
					echo '</div>';
					}
					
					if($ChangeClass->wipeQuestsEnabled()) {
					echo '<div class="checkbox">';
						echo '<label>';
							echo '<input type="checkbox" name="change_class_agree_quests" value="1"> I understand that my character quests will be cleared.';
						echo '</label>';
					echo '</div>';
					}
					
				echo '</div>';
			echo '</div>';
			
			echo '<div class="row">';
				echo '<div class="col-xs-8 col-xs-offset-2" style="margin-top:20px;">';
					
					echo '<button type="submit" name="change_class_submit" value="1" class="btn btn-block btn-primary">Change Class</button>';
					
				echo '</div>';
			echo '</div>';
		echo '</form>';
	
	}
	
} catch(Exception $ex) {
	message('error', $ex->getMessage());
}