<?php
/**
 * WebEngine CMS
 * https://webenginecms.org/
 * 
 * @version 1.1.1
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2019 Lautaro Angelico, All Rights Reserved
 * 
 * Licensed under the MIT license
 * http://opensource.org/licenses/MIT
 */

// Top Level Players
$levelRankingData = LoadCacheData('rankings_level.cache');
$topLevelLimit = 5;
if(is_array($levelRankingData)) {
    $Character = new Character();
    $topLevel = array_slice($levelRankingData, 0, $topLevelLimit+1);
    echo '<div class="panel panel-sidebar">';
        echo '<div class="panel-heading">';
            echo '<h3 class="panel-title">Top Level<a href="'.__BASE_URL__.'rankings/level" class="btn btn-yellow btn-xs pull-right" style="text-align:center;width:22px;">+</a></h3>';
        echo '</div>';
        echo '<div class="panel-body">';
            echo '<table class="table table-condensed">';
                echo '<tr>';
                    echo '<th></th>';
                    echo '<th>Player</th>';
                    echo '<th class="text-center">Level</th>';
                echo '</tr>';
                foreach($topLevel as $key => $row) {
                    if($key == 0) continue;
                    $characterIMG = $Character->GenerateCharacterClassAvatar($row[1],false,false);
                    echo '<tr>';
                        echo '<td><img src="'.$characterIMG.'" width="20px" height="auto" class="rounded_corners_image" /></td>';
                        echo '<td>'.$row[0].'</td>';
                        echo '<td class="text-center">'.$row[2].'</td>';
                    echo '</tr>';
                }
            echo '</table>';
        echo '</div>';
    echo '</div>';
}

// Server info block
$srvInfoCache = LoadCacheData('server_info.cache');
if(is_array($srvInfoCache)) {
	$srvInfo = explode("|", $srvInfoCache[1][0]);
	
	echo '<div class="panel panel-sidebar">';
		echo '<div class="panel-heading">';
			echo '<h3 class="panel-title">'.lang('sidebar_srvinfo_txt_1',true).'</h3>';
		echo '</div>';
		echo '<div class="panel-body">';
			echo '<table class="table">';
				
				echo '<tr><td>Version:</td><td>S14</td></tr>';
				echo '<tr><td>Experience:</td><td>10x</td></tr>';
				echo '<tr><td>Drop:</td><td>20%</td></tr>';
				echo '<tr><td>'.lang('sidebar_srvinfo_txt_2',true).'</td><td style="font-weight:bold;">'.number_format($srvInfo[0]).'</td></tr>';
				echo '<tr><td>'.lang('sidebar_srvinfo_txt_3',true).'</td><td style="font-weight:bold;">'.number_format($srvInfo[1]).'</td></tr>';
				echo '<tr><td>'.lang('sidebar_srvinfo_txt_4',true).'</td><td style="font-weight:bold;">'.number_format($srvInfo[2]).'</td></tr>';
				echo '<tr><td>'.lang('sidebar_srvinfo_txt_5',true).'</td><td style="color:#00aa00;font-weight:bold;">'.number_format($srvInfo[3]).'</td></tr>';
			echo '</table>';
		echo '</div>';
	echo '</div>';
}

// Event Timers
echo '<div class="panel panel-sidebar-events">';
	echo '<div class="panel-heading">';
		echo '<h3 class="panel-title">Events Schedule</h3>';
	echo '</div>';
	echo '<div class="panel-body">';
		echo '<table class="table table-condensed">';
			echo '<tr>';
				echo '<td><span id="bloodcastle_name"></span><br /><span class="smalltext">Starts In</span></td>';
				echo '<td class="text-right"><span id="bloodcastle_next"></span><br /><span class="smalltext" id="bloodcastle"></span></td>';
			echo '</tr>';
			echo '<tr>';
				echo '<td><span id="devilsquare_name"></span><br /><span class="smalltext">Starts In</span></td>';
				echo '<td class="text-right"><span id="devilsquare_next"></span><br /><span class="smalltext" id="devilsquare"></span></td>';
			echo '</tr>';
			echo '<tr>';
				echo '<td><span id="chaoscastle_name"></span><br /><span class="smalltext">Starts In</span></td>';
				echo '<td class="text-right"><span id="chaoscastle_next"></span><br /><span class="smalltext" id="chaoscastle"></span></td>';
			echo '</tr>';
			echo '<tr>';
				echo '<td><span id="dragoninvasion_name"></span><br /><span class="smalltext">Starts In</span></td>';
				echo '<td class="text-right"><span id="dragoninvasion_next"></span><br /><span class="smalltext" id="dragoninvasion"></span></td>';
			echo '</tr>';
			echo '<tr>';
				echo '<td><span id="goldeninvasion_name"></span><br /><span class="smalltext">Starts In</span></td>';
				echo '<td class="text-right"><span id="goldeninvasion_next"></span><br /><span class="smalltext" id="goldeninvasion"></span></td>';
			echo '</tr>';
			echo '<tr>';
				echo '<td><span id="skeletonking_name"></span><br /><span class="smalltext">Starts In</span></td>';
				echo '<td class="text-right"><span id="skeletonking_next"></span><br /><span class="smalltext" id="skeletonking"></span></td>';
			echo '</tr>';
			echo '<tr>';
				echo '<td><span id="whitewizard_name"></span><br /><span class="smalltext">Starts In</span></td>';
				echo '<td class="text-right"><span id="whitewizard_next"></span><br /><span class="smalltext" id="whitewizard"></span></td>';
			echo '</tr>';
			echo '<tr>';
				echo '<td><span id="castlesiege_name"></span><br /><span class="smalltext">Starts In</span></td>';
				echo '<td class="text-right"><span id="castlesiege_next"></span><br /><span class="smalltext" id="castlesiege"></span></td>';
			echo '</tr>';
		echo '</table>';
	echo '</div>';
echo '</div>';